import { StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";

const reviewImageSize = (dpr("wf") - dpr(80)) / 5;

export const ratingAndReviewsStyle = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        paddingBottom: dpr(20),
    },
    subCont: {
        backgroundColor: "white",
        marginHorizontal: dpr(20),
    },
    titleCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        paddingVertical: dpr(20),
    },
    title: {
        color: "#2C2C2C",
        fontSize: dpr(16),
        fontFamily: "DMSans_500Medium",
    },
    userCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        marginTop: dpr(20),
        width: "100%",
    },
    userSubCont: {
        flexDirection: "row",
        width: "60%",
    },
    userImg: {
        height: dpr(60),
        width: dpr(60),
        borderRadius: dpr(50),
        marginRight: dpr(12),
    },
    userName: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(15),
        color: "#2C2C2C",
        width: dpr(180),
        textAlign: 'left'
    },
    time: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(12),
        color: "#868686",
        textAlign: 'left'
    },
    userVerify: {
        marginTop: 3,
        alignItems: "center",
        flexDirection: "row",
    },
    userVerifyText: {
        marginLeft: 3,
        color: "#FCCA19",
        fontSize: dpr(12),
    },
    text: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        lineHeight: dpr(24),
        color: "#868686",
        marginTop: dpr(12),
        textAlign: 'left'
    },
    reviewImgCont: {
        marginTop: dpr(12),
        position: "relative",
    },
    reviewImg: {
        height: reviewImageSize,
        width: reviewImageSize,
        marginRight: dpr(10),
        borderRadius: 4,
        borderWidth: 1,
        borderColor: "#F3F3F3",
    },
    imageSeeAll: {
        position: "absolute",
        right: dpr(0),
        backgroundColor: "blue",
        zIndex: 999,
        height: reviewImageSize,
        width: reviewImageSize,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "rgba(248, 222, 215, 0.7)",
        borderRadius: 4,
    },
    imageSeeAllText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        color: "#2C2C2C",
    },
    seeAllCont: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
        marginTop: dpr(20),
        paddingBottom: dpr(20),
    },
    seeAllText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        marginRight: dpr(7),
    },
});
